/*
 * Copyright (c) 2018 ISP RAS (http://www.ispras.ru)
 * Ivannikov Institute for System Programming of the Russian Academy of Sciences
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/irqreturn.h>
#include <linux/iio/triggered_buffer.h>
#include <ldv/linux/emg/test_model.h>
#include <ldv/verifier/nondet.h>

struct iio_dev * dev;

static irqreturn_t irq_handler(int irq_id, void * data)
{
	ldv_invoke_reached();
	return IRQ_HANDLED;
}

static int __init ldv_init(void)
{
	ldv_invoke_test();
	return iio_triggered_buffer_setup(dev, irq_handler, NULL, NULL);
}

static void __exit ldv_exit(void)
{
	iio_triggered_buffer_cleanup(dev);
}

module_init(ldv_init);
module_exit(ldv_exit)

MODULE_LICENSE("GPL");
